import { API_END_POINTS } from "@/services/ApiEndpoints";
import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";

const initialState = {
  assignmentTask: null,
  isLoading: false,
};

// fetch calls
export const assignmentTask = createAsyncThunk(
  "assignmentTask/assignmentTask",
  async (_, { getState }) => {
    const token = getState().auth?.token;

    try {
      const response = await fetch(API_END_POINTS.getAssignmentTask, {
        headers: {
          Authorization: `Bearer ${token}`,
        },
      });

      if (!response.ok) throw new Error("Failed to fetch course progress");
      return await response.json();
    } catch (error) {
      throw error;
    }
  }
);
export const assignmentTaskSlice = createSlice({
  name: "assignmentTask",
  initialState,
  reducers: {
    getAssignmentTask: (state, action) => {
      state.assignmentTask = action.payload;
    },
  },
  extraReducers: (builder) => {
    builder.addCase(assignmentTask.fulfilled, (state, action) => {
      state.assignmentTask = action.payload;
      state.isLoading = false;
    });
    builder.addCase(assignmentTask.pending, (state, action) => {
      state.isLoading = true;
    });
  },
});

export default assignmentTaskSlice.reducer;
